% Japanese debt calculation: pre- vs post-Abenomics;

% parameters:
b0 = 1.4;           % initial debt (WEO);
r0 = 0.0043;        % initial real rate;
r1 = -0.0062;       % new real rate;
g0 = 0.01;          % initial GDP growth
g1 = 0.01;          % new GDP growth

t0 = 0.30;          % initial tax rate (includes SS contributions) -- from Hoshi and Ito.
t1 = 0.325;         % new tax rate. with sales tax;

G0 = 0.39;          % initial govt spending / GDP;
G1 = 0.4;           % new govt spending / GDP;

len = 10;           % length of calculation in years

% evolution;

bset = zeros(len+1,12);
bset(1,1:end) = b0*ones(1,12);

for zz=1:1:len
    
    % refinance at new rate
    % baseline scenario
    bset(zz+1,1) = bset(zz,1)*(1+r0)/(1+g0)+G0-t0;
    
    % decline in interest rates only
    bset(zz+1,2) = bset(zz,2)*(1+(r1*(zz<=10)+r0*(zz>10)))/(1+g0)+G0-t0;
    
    % only t
    bset(zz+1,3) = bset(zz,3)*(1+r0)/(1+g0)+G0-(t0+(t1-t0)*(zz==2)*0.6+(t1-t0)*(zz>2));
    
    % tax and spend policies
    bset(zz+1,4) = bset(zz,4)*(1+r0)/(1+g0)+((G1-G0)*(zz==1)+(G1-G0)*(zz==2)/2+G0)-(t0+(t1-t0)*(zz==2)*0.6+(t1-t0)*(zz>2));
    
    % all
    bset(zz+1,5) = bset(zz,5)*(1+(r1*(zz<=10)+r0*(zz>10)))/(1+g0)+((G1-G0)*(zz==1)+(G1-G0)*(zz==2)/2+G0)-(t0*(zz==1)+t1*(zz>=2));
    
    % G permanent
    bset(zz+1,6) = bset(zz,6)*(1+(r1*(zz<=10)+r0*(zz>10)))/(1+g0)+(G1)-(t0*(zz==1)+t1*(zz>=2));
    
    
    % refinance at old rate
    % baseline scenario
    bset(zz+1,7) = b0*(1+r0)/(1+g0)+(bset(zz,7)-b0)*(1+r0)/(1+g0)+G0-t0;
    
    % decline in interest rates only
    bset(zz+1,8) = b0*(1+(r1*(zz<=10)+r0*(zz>10)))/(1+g0)+(bset(zz,8)-b0)*(1+(r0*(zz<=10)+r0*(zz>10)))/(1+g0)+G0-t0;
    
    % only t
    bset(zz+1,9) = b0*(1+r0)/(1+g0)+(bset(zz,9)-b0)*(1+r0)/(1+g0)+G0-(t0+(t1-t0)*(zz==2)*0.6+(t1-t0)*(zz>2));
    
    % tax and spend policies
    bset(zz+1,10) = b0*(1+r0)/(1+g0)+(bset(zz,10)-b0)*(1+r0)/(1+g0)+((G1-G0)*(zz==1)+(G1-G0)*(zz==2)/2+G0)-(t0+(t1-t0)*(zz==2)*0.6+(t1-t0)*(zz>2));
    
    % all
    bset(zz+1,11) = b0*(1+(r1*(zz<=10)+r0*(zz>10)))/(1+g0)+(bset(zz,11)-b0)*(1+(r0*(zz<=10)+r0*(zz>10)))/(1+g0)+((G1-G0)*(zz==1)+(G1-G0)*(zz==2)/2+G0)-(t0*(zz==1)+t1*(zz>=2));
    
    % G permanent
    bset(zz+1,12) = b0*(1+(r1*(zz<=10)+r0*(zz>10)))/(1+g0)+(bset(zz,12)-b0)*(1+(r0*(zz<=10)+r0*(zz>10)))/(1+g0)+(G1)-(t0*(zz==1)+t1*(zz>=2));
    
end


disp(['Total Debt after 10 years without Abenomics = ' num2str(bset(11,7)*100) '% of GDP'])
disp(['Total Debt after 10 years with Abenomics = ' num2str(bset(11,11)*100) '% of GDP'])
disp(['Total effect of Abe = ' num2str((bset(11,7)-bset(11,11))*100) '% of GDP'])
disp(['Tax effect only = ' num2str((bset(11,7)-bset(11,9))*100) '% of GDP'])
disp(['Interest effect only = ' num2str((bset(11,7)-bset(11,8))*100) '% of GDP'])